<?php

class AopsCookieManager extends Aops {
	
	private static function setCookie($name, $value) {
		 setcookie($name , $value, time() + (1 * DAY_IN_SECONDS), COOKIEPATH, COOKIE_DOMAIN );
	}
	
	private static function getCookie($name) {
		return isset($_COOKIE[$name]) ? $_COOKIE[$name] : false;
	}
	
	private static function getCuSubmissionCookieName($cuID) {
		return 'CU_is_submitted_' . $cuID;
	}
	
	public static function setCuSubmissionCookie($cuID) {
		self::setCookie(self::getCuSubmissionCookieName($cuID), time());
	}
	
	public static function getCuSubmissionCookie($cuID) {
		return self::getCookie(self::getCuSubmissionCookieName($cuID));
	}	
}
